% ALPHA ENGINE DEFINITION
% Generated 07-Dec-2017 10:47:17

% SUGGESTED CITATION:
% Toyota 2.5L TNGA Prototype Engine from 2016 Aachen Paper - ALPHA Map Package. Version 2017-12. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2017.


% Constructor
engine = class_REVS_engine();
engine.name =  'Toyota 2.5L TNGA Prototype Engine from 2016 Aachen Paper'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.5; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [  0.00000000,	;  94.247780,	;  166.79372,	;  209.23546,	;  245.38090,	;  261.93785,	;  289.76595,	;  340.05864,	;  417.71304,	;  444.06423,	;  528.01493,	;  656.03975,	;  689.85323,	;  724.34589,	;  793.33121,	 ]; 
engine.full_throttle_torque_Nm = [  0.00000000,	;  170.00000,	;  210.07180,	;  215.88718,	;  232.97436,	;  237.30598,	;  239.41197,	;  233.69231,	;  249.12821,	;  250.63590,	;  249.77436,	;  229.69573,	;  220.87692,	;  189.32308,	; 0.00000000,	 ]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [  0.00000000,	;  793.33121,	;  837.75804,	 ]; 
engine.closed_throttle_torque_Nm = [  -19.939394,	; -57.047475,	; -58.016913,	 ]; 

% Fuel Map
engine.fuel_map_speed_radps = [  0.00000000,	 52.359878,	 78.539816,	 104.71976,	 130.89969,	 157.07963,	 183.25957,	 209.43951,	 235.61945,	 261.79939,	 287.97933,	 314.15927,	 340.33920,	 366.51914,	 392.69908,	 418.87902,	 471.23890,	 523.59878,	 575.95865,	 628.31853,	 680.67841,	 733.03829,	 785.39816,	 837.75804,	 ]; 
engine.fuel_map_torque_Nm = [  -59.899849,	; -25.949925,	;  8.0000000,	;  18.109829,	;  28.219658,	;  38.329487,	;  48.439316,	;  58.549145,	;  68.658974,	;  78.768803,	;  88.878632,	;  98.988462,	;  109.09829,	;  119.20812,	;  129.31795,	;  139.42778,	;  149.53761,	;  159.64744,	;  169.75726,	;  179.86709,	;  189.97692,	;  200.08675,	;  210.19658,	;  220.30641,	;  230.41624,	;  240.52607,	;  250.63590,	;  263.16769,	 ]; 
engine.fuel_map_gps = [
0.026759874, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, ;
0.086471690, 0.082410079, 0.080370812, 0.078678513, 0.078099824, 0.079655172, 0.084391107, 0.093270794, 0.10708630, 0.12640381, 0.15160237, 0.18288851, 0.22027877, 0.26362591, 0.31270182, 0.36728545, 0.49981498, 0.66363646, 0.83339635, 0.97816437,  1.0765092,  1.1343181,  1.1680939,  1.1930744, ;
0.10409418, 0.16992611, 0.20020291, 0.23076208, 0.26699197, 0.30867142, 0.35397935, 0.40226390, 0.45427978, 0.51139097, 0.57526484, 0.64688796, 0.72505718, 0.80533403, 0.88777779, 0.97401384,  1.1708705,  1.4429999,  1.7386215,  2.0111501,  2.1730143,  2.2969987,  2.4085790,  2.5172882, ;
0.098839226, 0.17872974, 0.21797246, 0.26381022, 0.31964551, 0.37935447, 0.44210171, 0.50594589, 0.56986968, 0.63891027, 0.71563876, 0.79935874, 0.88782707, 0.97568029,  1.0685167,  1.1671389,  1.3908407,  1.6745173,  1.9799788,  2.2629700,  2.4688280,  2.6370538,  2.7912953,  2.9421180, ;
0.092065776, 0.19534374, 0.24796957, 0.30344206, 0.37419182, 0.44867574, 0.52982166, 0.61158701, 0.68804621, 0.77088039, 0.86342936, 0.96106454,  1.0458498,  1.1454794,  1.2516323,  1.3629163,  1.6112103,  1.9056356,  2.2184545,  2.5132817,  2.7617812,  2.9774184,  3.1783091,  3.3751177, ;
0.084739030, 0.21891525, 0.28525317, 0.35055242, 0.42858719, 0.51661799, 0.61284724, 0.71037377, 0.80805710, 0.90949874,  1.0104203,  1.1151244,  1.2150689,  1.3235145,  1.4387374,  1.5601319,  1.8301486,  2.1367351,  2.4582396,  2.7697063,  3.0572063,  3.3211260,  3.5718910,  3.8184067, ;
0.077442379, 0.24478070, 0.32675600, 0.40563769, 0.49330594, 0.59517726, 0.70371291, 0.81634556, 0.92553983,  1.0392874,  1.1547763,  1.2699718,  1.3863955,  1.5045027,  1.6280014,  1.7585477,  2.0488867,  2.3691373,  2.7026494,  3.0353167,  3.3599296,  3.6720212,  3.9750279,  4.2745483, ;
0.071049462, 0.26921417, 0.36701119, 0.46215810, 0.56074316, 0.66886633, 0.78774021, 0.91222276,  1.0381210,  1.1669244,  1.2968116,  1.4238401,  1.5539321,  1.6820316,  1.8167504,  1.9590028,  2.2697235,  2.6045228,  2.9537995,  3.3116275,  3.6736852,  4.0341137,  4.3912134,  4.7465684, ;
0.067089272, 0.29190974, 0.40289030, 0.51349924, 0.62486138, 0.74165489, 0.87035465,  1.0086366,  1.1516244,  1.2958971,  1.4380407,  1.5701852,  1.7076260,  1.8534543,  2.0061480,  2.1637848,  2.4943670,  2.8442957,  3.2130548,  3.5998555,  4.0013469,  4.4111780,  4.8241711,  5.2378722, ;
0.067588094, 0.31568357, 0.44022163, 0.56539539, 0.68889624, 0.81534257, 0.95485951,  1.1077413,  1.2676598,  1.4278581,  1.5795044,  1.7185259,  1.8646848,  2.0302884,  2.2019237,  2.3746584,  2.7231188,  3.0894600,  3.4816056,  3.9013843,  4.3453362,  4.8066313,  5.2776068,  5.7520548, ;
0.075125352, 0.34233943, 0.47891189, 0.61721571, 0.75593032, 0.89685284,  1.0458433,  1.2056116,  1.3722201,  1.5456889,  1.7243715,  1.8854342,  2.0470901,  2.2261718,  2.4091428,  2.5915621,  2.9554802,  3.3410495,  3.7609213,  4.2179241,  4.7079468,  5.2235944,  5.7550366,  6.2926341, ;
0.092090766, 0.37314336, 0.51943122, 0.66895436, 0.81808886, 0.97326933,  1.1393142,  1.3058651,  1.4630092,  1.6420380,  1.8602530,  2.0591351,  2.2505123,  2.4379214,  2.6250408,  2.8123098,  3.1914575,  3.6007612,  4.0530463,  4.5515517,  5.0915631,  5.6650296,  6.2596789,  6.8627503, ;
0.11972674, 0.40978903, 0.56061271, 0.71559749, 0.87442896,  1.0463507,  1.2321715,  1.4155454,  1.5840732,  1.7631531,  1.9674640,  2.1963152,  2.4346064,  2.6426950,  2.8385162,  3.0327862,  3.4322144,  3.8713608,  4.3607806,  4.9047015,  5.4988346,  6.1338786,  6.7943730,  7.4648736, ;
0.15704653, 0.45502476, 0.60734896, 0.76487041, 0.93430104,  1.1190866,  1.3189279,  1.5194682,  1.7067491,  1.8910899,  2.0796131,  2.3242342,  2.5913161,  2.8234394,  3.0377088,  3.2480097,  3.6799085,  4.1566573,  4.6877894,  5.2801705,  5.9328701,  6.6331360,  7.3614862,  8.1005580, ;
0.20082230, 0.51107756, 0.66675932, 0.82632768,  1.0051933,  1.1995981,  1.4051257,  1.6186802,  1.8231876,  2.0233565,  2.2339823,  2.4769134,  2.7386278,  2.9850514,  3.2225028,  3.4576960,  3.9377646,  4.4611483,  5.0386647,  5.6813015,  6.3974487,  7.1657948,  7.9627940,  8.7702684, ;
0.24653585, 0.57499681, 0.74019470, 0.89833814,  1.0832184,  1.2888924,  1.5060064,  1.7297870,  1.9454780,  2.1629571,  2.3919315,  2.6326482,  2.8855594,  3.1435636,  3.4056772,  3.6701462,  4.2106651,  4.7896215,  5.4188469,  6.1127236,  6.8970815,  7.7346173,  8.5993491,  9.4733033, ;
0.28945459, 0.63770832, 0.80744788, 0.97752744,  1.1672596,  1.3797458,  1.6065665,  1.8375849,  2.0668820,  2.3007627,  2.5414910,  2.7804424,  3.0352652,  3.3147170,  3.6040226,  3.8984989,  4.5051554,  5.1468461,  5.8340591,  6.5822978,  7.4365230,  8.3417819,  9.2713663,  10.207821, ;
0.32447168, 0.70354284, 0.88846081,  1.0734580,  1.2671359,  1.4852623,  1.7165917,  1.9483318,  2.1843667,  2.4283335,  2.6807926,  2.9418552,  3.2189181,  3.5170960,  3.8308959,  4.1543301,  4.8284359,  5.5373137,  6.2887786,  7.1047549,  8.0192957,  8.9885952,  9.9781080,  10.970977, ;
0.34817767, 0.77114686, 0.98030008,  1.1867923,  1.3939145,  1.6139133,  1.8399217,  2.0689889,  2.3094671,  2.5649370,  2.8339335,  3.1208221,  3.4267427,  3.7520675,  4.0936541,  4.4466750,  5.1869533,  5.9649703,  6.7842775,  7.6685402,  8.6458488,  9.6753571,  10.717685,  11.759178, ;
0.35894968, 0.83366936,  1.0687678,  1.3008025,  1.5281348,  1.7511521,  1.9738251,  2.2070464,  2.4584670,  2.7260013,  3.0136459,  3.3251354,  3.6631331,  4.0218605,  4.3954640,  4.7798191,  5.5848183,  6.4322265,  7.3205078,  8.2687903,  9.3156236,  10.400443,  11.486738,  12.568466, ;
0.35606684, 0.88618608,  1.1497807,  1.4111318,  1.6666397,  1.9108775,  2.1429115,  2.3837895,  2.6448976,  2.9243312,  3.2318343,  3.5655341,  3.9386037,  4.3316364,  4.7377499,  5.1539027,  6.0232388,  6.9393042,  7.8969404,  8.9081428,  10.027902,  11.159428,  12.280334,  13.394975, ;
0.33968321, 0.92648193,  1.2189842,  1.5105852,  1.8000328,  2.0825792,  2.3374189,  2.5986605,  2.8712717,  3.1688670,  3.5022690,  3.8674550,  4.2637993,  4.6835472,  5.1194332,  5.5667929,  6.5011844,  7.4841768,  8.5109325,  9.6000208,  10.779348,  11.944573,  13.092381,  14.235334, ;
0.31051967, 0.95454754,  1.2755180,  1.5951493,  1.9110949,  2.2189726,  2.5158110,  2.8122956,  3.1198225,  3.4506020,  3.8125252,  4.2059909,  4.6275586,  5.0730583,  5.5372916,  6.0152835,  7.0161073,  8.0629510,  9.1551629,  10.315286,  11.558530,  12.745229,  13.916583,  15.086855, ;
0.26964417, 0.97090144,  1.3198272,  1.6668958,  2.0105647,  2.3500327,  2.6872869,  3.0270644,  3.3776434,  3.7477680,  4.1442644,  4.5684009,  5.0178691,  5.4911066,  5.9846083,  6.4939278,  7.5636003,  8.6691868,  9.8212944,  11.039056,  12.343024,  13.549019,  14.747482,  15.947378, ;
0.21852836, 0.97718260,  1.3549177,  1.7314416,  2.1067242,  2.4819576,  2.8598082,  3.2439189,  3.6393484,  4.0516413,  4.4858318,  4.9434366,  5.4245086,  5.9282395,  6.4526117,  6.9943390,  8.1356604,  9.2939197,  10.501788,  11.772177,  13.093719,  14.346494,  15.581054,  16.814859, ;
0.15930277, 0.97628666,  1.3845661,  1.7931120,  2.2030004,  2.6161583,  3.0351707,  3.4630003,  3.9028902,  4.3581743,  4.8318007,  5.3256548,  5.8406384,  6.3766425,  6.9325836,  7.5063006,  8.7171658,  9.9272580,  11.188950,  12.501820,  13.837515,  15.137076,  16.414407,  17.687101, ;
0.094713852, 0.97137016,  1.4117244,  1.8541047,  2.3002542,  2.7523447,  3.2127059,  3.6836036,  4.1671108,  4.6651096,  5.1792918,  5.7111129,  6.2615235,  6.8307106,  7.4179117,  8.0211194,  9.2831739,  10.561460,  11.877728,  13.226971,  14.582762,  15.923785,  17.246466,  18.561988, ;
0.010712047, 0.96282848,  1.4441718,  1.9297680,  2.4218842,  2.9227696,  3.4343523,  3.9580797,  4.4949280,  5.0455685,  5.6105832,  6.1905565,  6.7859077,  7.3965665,  8.0216666,  8.6594448,  9.9812220,  11.345832,  12.730900,  14.122454,  15.509453,  16.897010,  18.276367,  19.648071, ]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('MTE_GASOLINE');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [  0.00000000,	 10.000000,	 ]; 
engine.idle_speed_radps.table = [   68.067841,	;  68.067841,	 ]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
